
(* 4x3 flyways 1 xbot - send digital signal to PMC, macro trigger from DI *)
FUNCTION_BLOCK Example12_DImacro
	(*move xbot 1 to 60,60*)
	PMC_XYMotion1(PM_Controller := PM_Controller,Execute := Execute,cmdLB := 1,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.06,PosY := 0.06,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*clear macro 128*)
	PMC_ClearMacro1(PM_Controller := PM_Controller,Execute := PMC_XYMotion1.Done,MacroID := 128);

	(*write move to 900,60 to macro 128*)
	PMC_XYMotion2(PM_Controller := PM_Controller,Execute := PMC_ClearMacro1.Done,cmdLB := 3,XbotID := 128,Mode := 0,Type_ := 0,PosX := 0.9,PosY := 0.06,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*write move to 900,660 to macro 128*)
	PMC_XYMotion3(PM_Controller := PM_Controller,Execute := PMC_XYMotion2.Done,cmdLB := 4,XbotID := 128,Mode := 0,Type_ := 0,PosX := 0.9,PosY := 0.66,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*save macro 128*)
	PMC_SaveMacro1(PM_Controller := PM_Controller,Execute := PMC_XYMotion3.Done,MacroID := 128);

	(*set digital input 1 to trigger macro 128 on xbot 1*)
	DI_ID_array22[0] := 1;
	macro_ID_array22[0] := 128;
	xbotID_array22[0] := 1;
	PMC_ConfigDI2RunMacro1(PM_Controller := PM_Controller,Execute := PMC_SaveMacro1.Done,nDI := 1,DiID := DI_ID_array22,MacroID := macro_ID_array22,XbotID := xbotID_array22);

	(*set DI 1 to 0*)
	PMC_SendDigitalSignalToPMC1(PM_Controller := PM_Controller,Enable := PMC_ConfigDI2RunMacro1.Done,DoID := 1,Level := FALSE);

	Delay1(Execute := PMC_SendDigitalSignalToPMC1.Valid,Cycles := 1);

	(*set DI 1 to 1*)
	PMC_SendDigitalSignalToPMC2(PM_Controller := PM_Controller,Enable := Delay1.Done,DoID := 1,Level := TRUE);

	Done := PMC_SendDigitalSignalToPMC2.Valid;

END_FUNCTION_BLOCK
